// ---------------------------------------------------------------------------------------
//  BG.C - BGƃXvCg
//  ToDoFF̏`FbNiɑTextԁj
// ---------------------------------------------------------------------------------------

#include "../win32/common.h"
#include "../win32/windraw.h"
#include "../win32/winx68k.h"
#include "palette.h"
#include "tvram.h"
#include "crtc.h"
#include "bg.h"

#include "m68000.h"
#include "memory.h"

	BYTE	BG[0x8000];
	BYTE	Sprite_Regs[0x800];
	BYTE	BG_Regs[0x12];
	WORD	BG_CHREND = 0;
	WORD	BG_BG0TOP = 0;
	WORD	BG_BG0END = 0;
	WORD	BG_BG1TOP = 0;
	WORD	BG_BG1END = 0;
	BYTE	BG_CHRSIZE = 16;
	DWORD	BG_AdrMask = 511;
	DWORD	BG0ScrollX = 0, BG0ScrollY = 0;
	DWORD	BG1ScrollX = 0, BG1ScrollY = 0;

	long	BG_HAdjust = 0;
	long	BG_VLINE = 0;

	BYTE	BG_Dirty0[64*64];
	BYTE	BG_Dirty1[64*64];
	BYTE	BGCHR8[8*8*256];
	BYTE	BGCHR16[16*16*256];

	WORD	BG_LineBuf[1600];
	WORD	BG_PriBuf[1600];

	DWORD	VLINEBG = 0;

extern int toggle_bg0, toggle_bg1, toggle_sp;


void Save_BG( FILE *fp )
{
	fwrite( BG, 1, sizeof(BG), fp );
	fwrite( Sprite_Regs, 1, sizeof(Sprite_Regs), fp );
	fwrite( BG_Regs, 1, sizeof(BG_Regs), fp );
	fwrite( &BG_BG0TOP, 1, sizeof(BG_BG0TOP), fp );
	fwrite( &BG_BG0END, 1, sizeof(BG_BG0END), fp );
	fwrite( &BG_BG1TOP, 1, sizeof(BG_BG1TOP), fp );
	fwrite( &BG_BG1END, 1, sizeof(BG_BG1END), fp );
	fwrite( &BG_CHRSIZE, 1, sizeof(BG_CHRSIZE), fp );
	fwrite( &BG_AdrMask, 1, sizeof(BG_AdrMask), fp );
	fwrite( &BG0ScrollY, 1, sizeof(BG0ScrollY), fp );
	fwrite( &BG0ScrollX, 1, sizeof(BG0ScrollX), fp );
	fwrite( &BG1ScrollY, 1, sizeof(BG1ScrollY), fp );
	fwrite( &BG1ScrollX, 1, sizeof(BG1ScrollX), fp );
	fwrite( &BG_HAdjust, 1, sizeof(BG_HAdjust), fp );
	fwrite( &BG_VLINE, 1, sizeof(BG_VLINE), fp );
	fwrite( &BG_Dirty0, 1, sizeof(BG_Dirty0), fp );
	fwrite( &BG_HAdjust, 1, sizeof(BG_HAdjust), fp );
	fwrite( &BG_VLINE, 1, sizeof(BG_VLINE), fp );
	fwrite( &BG_Dirty0, 1, sizeof(BG_Dirty0), fp );
	fwrite( &BG_Dirty1, 1, sizeof(BG_Dirty1), fp );
	fwrite( BGCHR8, 1, sizeof(BGCHR8), fp );
	fwrite( BGCHR16, 1, sizeof(BGCHR16), fp );
	fwrite( BG_LineBuf, 1, sizeof(BG_LineBuf), fp );
	fwrite( BG_PriBuf, 1, sizeof(BG_PriBuf), fp );
	fwrite( &VLINEBG, 1, sizeof(VLINEBG), fp );
}

void Load_BG( FILE *fp )
{
	fread( BG, 1, sizeof(BG), fp );
	fread( Sprite_Regs, 1, sizeof(Sprite_Regs), fp );
	fread( BG_Regs, 1, sizeof(BG_Regs), fp );
	fread( &BG_BG0TOP, 1, sizeof(BG_BG0TOP), fp );
	fread( &BG_BG0END, 1, sizeof(BG_BG0END), fp );
	fread( &BG_BG1TOP, 1, sizeof(BG_BG1TOP), fp );
	fread( &BG_BG1END, 1, sizeof(BG_BG1END), fp );
	fread( &BG_CHRSIZE, 1, sizeof(BG_CHRSIZE), fp );
	fread( &BG_AdrMask, 1, sizeof(BG_AdrMask), fp );
	fread( &BG0ScrollY, 1, sizeof(BG0ScrollY), fp );
	fread( &BG0ScrollX, 1, sizeof(BG0ScrollX), fp );
	fread( &BG1ScrollY, 1, sizeof(BG1ScrollY), fp );
	fread( &BG1ScrollX, 1, sizeof(BG1ScrollX), fp );
	fread( &BG_HAdjust, 1, sizeof(BG_HAdjust), fp );
	fread( &BG_VLINE, 1, sizeof(BG_VLINE), fp );
	fread( &BG_Dirty0, 1, sizeof(BG_Dirty0), fp );
	fread( &BG_HAdjust, 1, sizeof(BG_HAdjust), fp );
	fread( &BG_VLINE, 1, sizeof(BG_VLINE), fp );
	fread( &BG_Dirty0, 1, sizeof(BG_Dirty0), fp );
	fread( &BG_Dirty1, 1, sizeof(BG_Dirty1), fp );
	fread( BGCHR8, 1, sizeof(BGCHR8), fp );
	fread( BGCHR16, 1, sizeof(BGCHR16), fp );
	fread( BG_LineBuf, 1, sizeof(BG_LineBuf), fp );
	fread( BG_PriBuf, 1, sizeof(BG_PriBuf), fp );
	fread( &VLINEBG, 1, sizeof(VLINEBG), fp );
}

// -----------------------------------------------------------------------
//   
// -----------------------------------------------------------------------
void BG_Init(void)
{
	DWORD i;
	ZeroMemory(Sprite_Regs, 0x800);
	ZeroMemory(BG, 0x8000);
	ZeroMemory(BGCHR8, 8*8*256);
	ZeroMemory(BGCHR16, 16*16*256);
	ZeroMemory(BG_LineBuf, 1600*2);
	for (i=0; i<0x12; i++)
		BG_Write(0xeb0800+i, 0);
	BG_CHREND = 0x8000;
}


// -----------------------------------------------------------------------
//   I/O Read
// -----------------------------------------------------------------------
BYTE FASTCALL BG_Read(DWORD adr)
{
	if ((adr>=0xeb0000)&&(adr<0xeb0400))
	{
		adr -= 0xeb0000;
		adr ^= 1;
		return Sprite_Regs[adr];
	}
	else if ((adr>=0xeb0800)&&(adr<0xeb0812))
		return BG_Regs[adr-0xeb0800];
	else if ((adr>=0xeb8000)&&(adr<0xec0000))
		return BG[adr-0xeb8000];
	else
		return 0xff;
}


// -----------------------------------------------------------------------
//   I/O Write
// -----------------------------------------------------------------------
void FASTCALL BG_Write(DWORD adr, BYTE data)
{
	DWORD bg16chr;
	int s1, s2, v = 0;
	s1 = (((BG_Regs[0x11]  &4)?2:1)-((BG_Regs[0x11]  &16)?1:0));
	s2 = (((CRTC_Regs[0x29]&4)?2:1)-((CRTC_Regs[0x29]&16)?1:0));
	if ( !(BG_Regs[0x11]&16) ) v = ((BG_Regs[0x0f]>>s1)-(CRTC_Regs[0x0d]>>s2));
	if ((adr>=0xeb0000)&&(adr<0xeb0400))
	{
/*{
FILE* fp = fopen("_sprite.txt", "a");
if (fp) fprintf(fp, "Adr:$%08X  Data:$%02X @ $%08X\n", adr, data, regs.pc);
fclose(fp);
}*/
		adr &= 0x3ff;
		adr ^= 1;
		if (Sprite_Regs[adr] != data)
		{
			_asm
			{
				mov	ebx, adr
				and	ebx, 3f8h
				mov	bx, word ptr Sprite_Regs[ebx+2]
				sub	bx, 16
				add	ebx, BG_VLINE
				sub	ebx, v
				and	ebx, 3ffh
				mov	al, 16
			spsetdirtylp1:
				mov	byte ptr TextDirtyLine[ebx], 1
				inc	bx
				and	bx, 3ffh
				dec	al
				jnz	spsetdirtylp1
			}
			Sprite_Regs[adr] = data;
			_asm
			{
				mov	ebx, adr
				and	ebx, 3f8h
				mov	bx, word ptr Sprite_Regs[ebx+2]
				sub	bx, 16
				add	ebx, BG_VLINE
				sub	ebx, v
				and	ebx, 3ffh
				mov	al, 16
			spsetdirtylp2:
				mov	byte ptr TextDirtyLine[ebx], 1
				inc	bx
				and	bx, 3ffh
				dec	al
				jnz	spsetdirtylp2
			}
		}
	}
	else if ((adr>=0xeb0800)&&(adr<0xeb0812))
	{
		adr -= 0xeb0800;
		if (BG_Regs[adr]==data) return;	// f[^ɕω΋A
		BG_Regs[adr] = data;
		switch(adr)
		{
		case 0x00:
		case 0x01:
			BG0ScrollX = (((DWORD)BG_Regs[0x00]<<8)+BG_Regs[0x01])&BG_AdrMask;
			TVRAM_SetAllDirty();
			break;
		case 0x02:
		case 0x03:
			BG0ScrollY = (((DWORD)BG_Regs[0x02]<<8)+BG_Regs[0x03])&BG_AdrMask;
			TVRAM_SetAllDirty();
			break;
		case 0x04:
		case 0x05:
			BG1ScrollX = (((DWORD)BG_Regs[0x04]<<8)+BG_Regs[0x05])&BG_AdrMask;
			TVRAM_SetAllDirty();
			break;
		case 0x06:
		case 0x07:
			BG1ScrollY = (((DWORD)BG_Regs[0x06]<<8)+BG_Regs[0x07])&BG_AdrMask;
			TVRAM_SetAllDirty();
			break;

		case 0x08:		// BG On/Off Changed
			TVRAM_SetAllDirty();
			break;

		case 0x0d:
			BG_HAdjust = ((long)BG_Regs[0x0d]-(CRTC_HSTART+4))*8;				// ͉𑜓xɂ1/2͂ȂHiTetrisj
			TVRAM_SetAllDirty();
			break;
		case 0x0f:
			BG_VLINE = ((long)BG_Regs[0x0f]-CRTC_VSTART)/((BG_Regs[0x11]&4)?1:2);	// BGƂ̑Ă鎞̍
			TVRAM_SetAllDirty();
			break;

		case 0x11:		// BG ScreenRes Changed
			if (data&3)
			{
				if ((BG_BG0TOP==0x4000)||(BG_BG1TOP==0x4000))
					BG_CHREND = 0x4000;
				else if ((BG_BG0TOP==0x6000)||(BG_BG1TOP==0x6000))
					BG_CHREND = 0x6000;
				else
					BG_CHREND = 0x8000;
			}
			else
				BG_CHREND = 0x2000;
			BG_CHRSIZE = ((data&3)?16:8);
			BG_AdrMask = ((data&3)?1023:511);
			BG_HAdjust = ((long)BG_Regs[0x0d]-(CRTC_HSTART+4))*8;				// ͉𑜓xɂ1/2͂ȂHiTetrisj
			BG_VLINE = ((long)BG_Regs[0x0f]-CRTC_VSTART)/((BG_Regs[0x11]&4)?1:2);	// BGƂ̑Ă鎞̍
			break;
		case 0x09:		// BG Plane Cfg Changed
			TVRAM_SetAllDirty();
			if (data&0x08)
			{
				if (data&0x30)
				{
					BG_BG1TOP = 0x6000;
					BG_BG1END = 0x8000;
				}
				else
				{
					BG_BG1TOP = 0x4000;
					BG_BG1END = 0x6000;
				}
			}
			else
				BG_BG1TOP = BG_BG1END = 0;
			if (data&0x01)
			{
				if (data&0x06)
				{
					BG_BG0TOP = 0x6000;
					BG_BG0END = 0x8000;
				}
				else
				{
					BG_BG0TOP = 0x4000;
					BG_BG0END = 0x6000;
				}
			}
			else
				BG_BG0TOP = BG_BG0END = 0;
			if (BG_Regs[0x11]&3)
			{
				if ((BG_BG0TOP==0x4000)||(BG_BG1TOP==0x4000))
					BG_CHREND = 0x4000;
				else if ((BG_BG0TOP==0x6000)||(BG_BG1TOP==0x6000))
					BG_CHREND = 0x6000;
				else
					BG_CHREND = 0x8000;
			}
			break;
		case 0x0b:
			break;
		}
		Draw_DrawFlag = 1;

	}
	else if ((adr>=0xeb8000)&&(adr<0xec0000))
	{
		adr -= 0xeb8000;
		if (BG[adr]==data) return;			// f[^ɕω΋A
		BG[adr] = data;
		if (adr<0x2000)
		{
			BGCHR8[adr*2]   = data>>4;
			BGCHR8[adr*2+1] = data&15;
		}
		bg16chr = ((adr&3)*2)+((adr&0x3c)*4)+((adr&0x40)>>3)+((adr&0x7f80)*2);
		BGCHR16[bg16chr]   = data>>4;
		BGCHR16[bg16chr+1] = data&15;

		if (adr<BG_CHREND)				// p^[GA
		{
			TVRAM_SetAllDirty();
		}
		if ((adr>=BG_BG1TOP)&&(adr<BG_BG1END))	// BG1 MAPGA
		{
			TVRAM_SetAllDirty();
		}
		if ((adr>=BG_BG0TOP)&&(adr<BG_BG0END))	// BG0 MAPGA
		{
			TVRAM_SetAllDirty();
		}
	}
}


#include	"bg.x86"
// -----------------------------------------------------------------------
//   1C̕`
// -----------------------------------------------------------------------
LABEL void FASTCALL BG_DrawLine(int opaq, int gd) {

	__asm {
			pushf
			push	ebx
			push	esi
			push	edi
			push	edx
			push	ebp

			//xor	eax, eax
			mov	ax, TextPal[0]
			shl	eax, 16
			mov	ax, TextPal[0]
			mov	ebx, 0xffffffff
			mov	edi, 16*2
			or	ecx, ecx			// ecx = opaq
			jz	noclrloop
			mov	ecx, TextDotX
			shr	ecx, 1
		BGLineClr_lp:
			mov	dword ptr BG_LineBuf[edi], eax
			mov	dword ptr BG_PriBuf[edi], ebx	// SPԂ̃vCIeB񏉊
			add	edi, 4
			loop	BGLineClr_lp
			jmp	bgclrloopend

		noclrloop:
			mov	ecx, TextDotX
			shr	ecx, 1
		BGLineClr_lp2:
			mov	dword ptr BG_PriBuf[edi], ebx	// SPԂ̃vCIeB񏉊
			add	edi, 4
			loop	BGLineClr_lp2

		bgclrloopend:
			or	edx, edx			// edx = gd
			je	BG_NOGRP

			cmp	BG_CHRSIZE, 8
			jne	BG16


			test toggle_sp, 1
			jnz no_draw_sp0_0
			Sprite_DrawLineMcr(81, 1)
no_draw_sp0_0:


			test	BG_Regs[9], 8
			je	BG8_1skiped


			test toggle_bg1, 1
			jnz no_draw_bg1_0_0
			BG_DrawLineMcr8(1, BG_BG1TOP, BG1ScrollX, BG1ScrollY)
no_draw_bg1_0_0:


		BG8_1skiped:
			test toggle_sp, 1
			jnz no_draw_sp0_1
			Sprite_DrawLineMcr(82, 2)
no_draw_sp0_1:


			test	BG_Regs[9], 1
			je	BG_0skiped

			test toggle_bg0, 1
			jnz no_draw_bg0_0_0
			BG_DrawLineMcr8(0, BG_BG0TOP, BG0ScrollX, BG0ScrollY)
no_draw_bg0_0_0:
			
			jmp	BG_0skiped

		BG16:

			test toggle_sp, 1
			jnz no_draw_sp1_0
			Sprite_DrawLineMcr(161, 1)
no_draw_sp1_0:


;			test	BG_Regs[9], 8
;			je	BG16_1skiped
;			BG_DrawLineMcr16(1, BG_BG1TOP, BG1ScrollX, BG1ScrollY)
;		BG16_1skiped:

			test toggle_sp, 1
			jnz no_draw_sp1_1
			Sprite_DrawLineMcr(162, 2)
no_draw_sp1_1:


			test	BG_Regs[9], 1
			je	BG_0skiped

			test toggle_bg0, 1
			jnz no_draw_bg0_1_0
			BG_DrawLineMcr16(0, BG_BG0TOP, BG0ScrollX, BG0ScrollY)
no_draw_bg0_1_0:

			jmp	BG_0skiped

		BG_NOGRP:
			cmp	BG_CHRSIZE, 8
			jne	BG16_ng


			test toggle_sp, 1
			jnz no_draw_sp2_0
			Sprite_DrawLineMcr(ng81, 1)
no_draw_sp2_0:


			test	BG_Regs[9], 8
			je	BG8_ng_1skiped

			test toggle_bg1, 1
			jnz no_draw_bg1_2_0
			BG_DrawLineMcr8_ng(1, BG_BG1TOP, BG1ScrollX, BG1ScrollY)
no_draw_bg1_2_0:
		
	BG8_ng_1skiped:

			
			test toggle_sp, 1
			jnz no_draw_sp2_1
			Sprite_DrawLineMcr(ng82, 2)
no_draw_sp2_1:
			
				
			test	BG_Regs[9], 1
			je	BG_0skiped

			test toggle_bg0, 1
			jnz no_draw_bg0_2_0
			BG_DrawLineMcr8_ng(0, BG_BG0TOP, BG0ScrollX, BG0ScrollY)
no_draw_bg0_2_0:

			jmp	BG_0skiped

		BG16_ng:

			test toggle_sp, 1
			jnz no_draw_sp3_0
			Sprite_DrawLineMcr(ng161, 1)
no_draw_sp3_0:

				
;			test	BG_Regs[9], 8
;			je	BG16_ng_1skiped
;			BG_DrawLineMcr16_ng(1, BG_BG1TOP, BG1ScrollX, BG1ScrollY)
;		BG16_ng_1skiped:

			test toggle_sp, 1
			jnz no_draw_sp3_1
			Sprite_DrawLineMcr(ng162, 2)
no_draw_sp3_1:

			test	BG_Regs[9], 1
			je	BG_0skiped

			test toggle_bg0, 1
			jnz no_draw_bg0_3_0
			BG_DrawLineMcr16_ng(0, BG_BG0TOP, BG0ScrollX, BG0ScrollY)
no_draw_bg0_3_0:
		
	BG_0skiped:

			test toggle_sp, 1
			jnz no_draw_sp3_2
			Sprite_DrawLineMcr(163, 3)
no_draw_sp3_2:

			pop	ebp
			pop	edx
			pop	edi
			pop	esi
			pop	ebx
			popf
			ret
	}
}
